#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{

	
	

	[TestFixture]
	public class BOL_DaylightSavingsTypeDefinition : BaseTest 
	{
		private class DstMockChild : BOL.DaylightSavingsTypeDefinition
		{
			public DstMockChild( COMMON.DaylightSavingsType type ) 
				: base( type ) {}
		}

		private DstMockChild _testDstDef;
		private const COMMON.DaylightSavingsType TestDstType = COMMON.DaylightSavingsType.UsaStandard;
		private static readonly string TestDstTypeName = Common.StrRes.OtherMsg.Common.DstTypeUsaStandard().ResString;

		[SetUp]
		protected void SetUp()
		{
			this.BaseSetUp();

			_testDstDef = new DstMockChild( TestDstType );
		}

		[TearDown]
		protected void TearDown()
		{
			_testDstDef = null;
		}

		[Test]
		public void Type_Pass()
		{
			Assert.AreEqual( TestDstType, _testDstDef.Type );
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void Type_Fail() {}

		[Test]
		public void Name_Pass()
		{
			Assert.AreEqual( TestDstTypeName, _testDstDef.Name );
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void Name_Fail() {}

		[Test]
		public void GetAllSortedByUse_Pass_1()
		{
			BusinessObjectSortedHashList _list = DaylightSavingsTypeDefinition.GetAllSortedByUse();
			
			Assert.IsNotNull( _list );
			Assert.IsTrue( _list.Count > 0 );
		}

		[Test]
		public void GetAllSortedByUse_Pass_2()
		{
			BusinessObjectSortedHashList _list = DaylightSavingsTypeDefinition.GetAllSortedByUse();			
			IEnumerator _en = _list.GetEnumerator();
			
			_en.MoveNext();
			Assert.AreEqual( COMMON.DaylightSavingsType.UsaStandard, ((DaylightSavingsTypeDefinition)_en.Current).Type );

			_en.MoveNext();
			Assert.AreEqual( COMMON.DaylightSavingsType.DoNotObserve, ((DaylightSavingsTypeDefinition)_en.Current).Type );

			_en.MoveNext();
			Assert.AreEqual( COMMON.DaylightSavingsType.Custom, ((DaylightSavingsTypeDefinition)_en.Current).Type );
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void GetAllSortedByUse_Fail() {}

		[Test]
		public void GetObjectID_Pass()
		{
			Assert.AreEqual( TestDstType, _testDstDef.GetObjectID() );
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void GetObjectID_Fail() {}

		[Test]
		public void GetDaylightSavingsTypeFromId_Pass()
		{
			Assert.AreEqual( COMMON.DaylightSavingsType.DoNotObserve, DaylightSavingsTypeDefinition.GetDaylightSavingsTypeFromId( (int)COMMON.DaylightSavingsType.DoNotObserve ) );
			Assert.AreEqual( COMMON.DaylightSavingsType.UsaStandard, DaylightSavingsTypeDefinition.GetDaylightSavingsTypeFromId( (int)COMMON.DaylightSavingsType.UsaStandard ) );
			Assert.AreEqual( COMMON.DaylightSavingsType.Custom, DaylightSavingsTypeDefinition.GetDaylightSavingsTypeFromId( (int)COMMON.DaylightSavingsType.Custom ) );
			Assert.AreEqual( COMMON.DaylightSavingsType.Unknown, DaylightSavingsTypeDefinition.GetDaylightSavingsTypeFromId( (int)COMMON.DaylightSavingsType.Unknown ) );
		}

		[Test]
		[ExpectedException(typeof(ArgumentOutOfRangeException))]
		public void GetDaylightSavingsTypeFromId_Fail()
		{
			DaylightSavingsTypeDefinition.GetDaylightSavingsTypeFromId( -1 );
		}

		[Test]
		public void GetDaylightSavingsTypeId_Pass()
		{
			Assert.AreEqual( 1, DaylightSavingsTypeDefinition.GetDaylightSavingsTypeId( COMMON.DaylightSavingsType.DoNotObserve ) );
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void GetDaylightSavingsTypeId_Fail() {}
	}
}

#endif
